/********************************** (C) COPYRIGHT *******************************
* File Name          : USBH.C
* Author             : MJX
* Version            : V1.00
* Date               : 2020/05/15
* Description        : USBͨòغ   										 
*******************************************************************************/



/******************************************************************************/
/* ͷļ */
#include "MAIN.H"	 															/* ͷļ */

/******************************************************************************/
/*  */

/* ȡ豸 */
UINT8C	SetupGetDevDescr[ ] = { USB_REQ_TYP_IN, USB_GET_DESCRIPTOR, 0x00, USB_DESCR_TYP_DEVICE, 0x00, 0x00, sizeof( USB_DEV_DESCR ), 0x00 };

/* ȡ */
UINT8C	SetupGetCfgDescr[ ] = { USB_REQ_TYP_IN, USB_GET_DESCRIPTOR, 0x00, USB_DESCR_TYP_CONFIG, 0x00, 0x00, 0x04, 0x00 };

/* ȡַ */
UINT8C	SetupGetStrDescr[ ] = { USB_REQ_TYP_IN, USB_GET_DESCRIPTOR, 0x00, USB_DESCR_TYP_STRING, 0x09, 0x04, 0x04, 0x00 };

/* USBַ */
UINT8C	SetupSetUsbAddr[ ] = { USB_REQ_TYP_OUT, USB_SET_ADDRESS, USB_DEVICE_ADDR, 0x00, 0x00, 0x00, 0x00, 0x00 };

/* USB */
UINT8C	SetupSetUsbConfig[ ] = { USB_REQ_TYP_OUT, USB_SET_CONFIGURATION, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

/* ˵STALL */
UINT8C	SetupClrEndpStall[ ] = { USB_REQ_TYP_OUT | USB_REQ_RECIP_ENDP, USB_CLEAR_FEATURE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

/* ȡHUB */
UINT8C	SetupGetHubDescr[ ] = { HUB_GET_HUB_DESCRIPTOR, HUB_GET_DESCRIPTOR, 0x00, USB_DESCR_TYP_HUB, 0x00, 0x00, sizeof( USB_HUB_DESCR ), 0x00 };

/*  */
UINT8X	UsbDevEndp0Size = DEFAULT_ENDP0_SIZE;									/* USB豸Ķ˵0ߴ */
UINT8X	RxBuffer[ MAX_PACKET_SIZE ] _at_ 0x0000;  								/* IN, must even address */
UINT8X	TxBuffer[ MAX_PACKET_SIZE ] _at_ 0x0040;  								/* OUT, must even address */
UINT8	RootHubId = 0x00;														/* ǰڲroot-hub˿ں:0=HUB0,1=HUB1,2=HUB2,3=HUB3 */

struct _ROOT_HUB_DEVICE xdata RootHubDev[ 4 ];									/* HUB豸ؽṹ嶨 */

#define DEF_CTRL_TRANS_TIMEOVER_COUNT 		50000								/* ƴʱʱ */

#pragma NOAREGS

/*******************************************************************************
* Function Name  : USBH_DisableRootHubPort
* Description    : USBرָROOT-HUB˿
*				   رָROOT-HUB˿,ʵӲѾԶر,˴ֻһЩṹ״̬	  
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USBH_DisableRootHubPort( UINT8 index ) 
{
	if( ( RootHubDev[ index ].bStatus == ROOT_DEV_SUCCESS ) ||	
		( RootHubDev[ index ].DeviceIndex == 3  )  )
	{
	}	
	else
	{
		RootHubDev[ index ].bStatus = ROOT_DEV_DISCONNECT;
	}
	switch( index ) 
	{
		case 0: UHUB01_CTRL = UHUB01_CTRL & 0xF0 | bUH0_PD_EN; break;  			/* йHUB0Ŀ,ʵϲҪ */
		case 1: UHUB01_CTRL = UHUB01_CTRL & 0x0F | bUH1_PD_EN; break;  			/* йHUB1Ŀ,ʵϲҪ */
		case 2: UHUB23_CTRL = UHUB23_CTRL & 0xF0 | bUH2_PD_EN; break;  			/* йHUB2Ŀ,ʵϲҪ */
		case 3: UHUB23_CTRL = UHUB23_CTRL & 0x0F | bUH3_PD_EN; break;  			/* йHUB3Ŀ,ʵϲҪ */
		default: break;
	}
}

/*******************************************************************************
* Function Name  : USBH_Check_RootHubStatus
* Description    : USBָROOT-HUB˿Ƿʹ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 USBH_Check_RootHubStatus( UINT8 index ) 
{
	return( ( index < 2 ? UHUB01_CTRL : UHUB23_CTRL ) & ( index & 1 ? bUH1_PORT_EN : bUH0_PORT_EN ) );
}

/*******************************************************************************
* Function Name  : USBH_SetSelfAddr
* Description    : USBõǰҪUSB豸ַ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USBH_SetSelfAddr( UINT8 addr ) 
{
	USB_DEV_AD = USB_DEV_AD & bUDA_GP_BIT | addr & 0x7F;
}

/*******************************************************************************
* Function Name  : USBH_SetSelfSpeed
* Description    : USBUSBٶ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USBH_SetSelfSpeed( UINT8 speed ) 
{
	if ( speed ) 
	{  
		/* ȫ */
		USB_CTRL &= ~ bUC_LOW_SPEED;  
		UH_SETUP &= ~ bUH_PRE_PID_EN;  											/* ֹPRE PID */
	}
	else 
	{
		/*  */
		USB_CTRL |= bUC_LOW_SPEED;  
	}
}

/*******************************************************************************
* Function Name  : USBH_ResetRootHubPort
* Description    : USBλӦ˿ڵ
*				   ⵽豸,λӦ˿ڵ,Ϊö豸׼,ΪĬΪȫ
* Input          : mod: 0=reset and wait end, 1=begin reset, 2=end reset
* Output         : None
* Return         : None
*******************************************************************************/
void USBH_ResetRootHubPort( UINT8 index, UINT8 mod )
{
	UsbDevEndp0Size = DEFAULT_ENDP0_SIZE;  										/* USB豸Ķ˵0ߴ */
	USBH_SetSelfAddr( 0x00 );
	USBH_SetSelfSpeed( 1 );  													/* ĬΪȫ */
	if( mod <= 1 ) 
	{
		switch( index ) 
		{
			case 0: UHUB01_CTRL = UHUB01_CTRL & 0xF0 | bUH0_PD_EN | bUH0_BUS_RESET; break;  /* ĬΪȫ,ʼλ */
			case 1: UHUB01_CTRL = UHUB01_CTRL & 0x0F | bUH1_PD_EN | bUH1_BUS_RESET; break;  /* ĬΪȫ,ʼλ */
			case 2: UHUB23_CTRL = UHUB23_CTRL & 0xF0 | bUH2_PD_EN | bUH2_BUS_RESET; break;  /* ĬΪȫ,ʼλ */
			case 3: UHUB23_CTRL = UHUB23_CTRL & 0x0F | bUH3_PD_EN | bUH3_BUS_RESET; break;  /* ĬΪȫ,ʼλ */
			default: break;
		}
	}
	if( mod == 0 )
	{ 
		mDelaymS( BUS_RESET_TIME );  											/* λʱ10mS20mS */
	}
	if( mod != 1 ) 
	{
		switch( index ) 
		{
			case 0: UHUB01_CTRL = UHUB01_CTRL & ~ bUH0_BUS_RESET; break;  /* λ */
			case 1: UHUB01_CTRL = UHUB01_CTRL & ~ bUH1_BUS_RESET; break;  /* λ */
			case 2: UHUB23_CTRL = UHUB23_CTRL & ~ bUH2_BUS_RESET; break;  /* λ */
			case 3: UHUB23_CTRL = UHUB23_CTRL & ~ bUH3_BUS_RESET; break;  /* λ */
			default: break;
		}
	}
	mDelayuS( 2 );
	UIF_DETECT = 0;  															/* жϱ־ */
}

/*******************************************************************************
* Function Name  : USBH_EnableRootHubPort
* Description    : USBʹROOT-HUB˿
*				   ʹROOT-HUB˿,ӦbUH_PORT_EN1˿,豸Ͽܵ·ʧ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 USBH_EnableRootHubPort( UINT8 index )
{
	if( index < 4 ) 
	{
		if( RootHubDev[ index ].bStatus < ROOT_DEV_CONNECTED ) 
		{
			RootHubDev[ index ].bStatus = ROOT_DEV_CONNECTED;
		}
		if( USB_HUB_ST & ( bUHS_H0_ATTACH << index ) ) 
		{  
			/* 豸 bUHS_H?_ATTACH */
			if( USBH_Check_RootHubStatus( index ) == 0x00 ) 
			{  
				/* δʹ	*/
				RootHubDev[ index ].bSpeed = USB_HUB_ST & ( bUHS_HM0_LEVEL << index ) ? 0 : 1;
				if( RootHubDev[ index ].bSpeed == 0 ) 
				{
					if( index < 2 ) 
					{
						UHUB01_CTRL |= index & 1 ? bUH1_LOW_SPEED : bUH0_LOW_SPEED;/*  */
					}
					else
					{ 
						UHUB23_CTRL |= index & 1 ? bUH3_LOW_SPEED : bUH2_LOW_SPEED;/*  */
					}
				}
			}
			if( index < 2 ) 
			{
				UHUB01_CTRL |= index & 1 ? bUH1_PORT_EN : bUH0_PORT_EN;  		/* ʹHUB˿ */
			}
			else 
			{
				UHUB23_CTRL |= index & 1 ? bUH3_PORT_EN : bUH2_PORT_EN;  		/* ʹHUB˿ */
			}
			return( ERR_SUCCESS );
		}
	}
	return( ERR_USB_DISCON );
}

/*******************************************************************************
* Function Name  : USBH_SelectHubPort
* Description    : USBѡָROOT-HUB˿
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USBH_SelectHubPort( UINT8 index ) 
{
	UsbDevEndp0Size = RootHubDev[ index ].bEp0MaxPks;  							/* ˵0ĳ */
	USBH_SetSelfAddr( RootHubDev[ index ].bStatus >= ROOT_DEV_SUCCESS ? RootHubDev[ index ].bAddress : 0 );
	USBH_SetSelfSpeed( RootHubDev[ index ].bSpeed );  							/* õǰUSBٶ */
	RootHubId = index;

	/* жǷHUBµ豸,HUBδǷǵ豸 */
	if( RootHubDev[ index ].bAddress >= 0x10 )
	{
		if( RootHubDev[ index ].bSpeed == 0x00 )
		{
			/* HUB豸,ҪPRE PID */
			UH_SETUP |= bUH_PRE_PID_EN;  
		}
	}
}

/*******************************************************************************
* Function Name  : USBH_Transact
* Description    : USBִд
*			       ĿĶ˵ַ/PID,ͬ־,20uSΪλNAKʱ
*				  (0,0xFFFF),0ɹ,ʱ/;
* Input          : endp_pid: 4λtoken_pid, 4λǶ˵ַ
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 USBH_Transact( UINT8 endp_pid, UINT8 tog, UINT16 timeout )
{ 
#define	TransRetry	UEP0_T_LEN	// Լڴ
	UINT8	r;
	UINT16	i;
	UH_RX_CTRL = UH_TX_CTRL = tog;

	TransRetry = 0;
	do 
	{
		UH_EP_PID = endp_pid;  // ָPIDĿĶ˵ */
		UIF_TRANSFER = 0;  //  */
		for ( i = WAIT_USB_TOUT_200US; i != 0 && UIF_TRANSFER == 0; i -- ) 
		{
			mDelayuS( 40 );
			CHIP_ID++;
		}
		UH_EP_PID = 0x00;  // ֹͣUSB */
//		LED_TMP = 1;
//		if ( s != ERR_SUCCESS ) return( s );  // жϳʱ,Ӳ쳣
		if ( UIF_TRANSFER == 0 ) return( ERR_USB_UNKNOWN );
//		if ( UIF_DETECT ) {  // USB豸¼
//			mDelayuS( 200 );  // ȴ
//			UIF_DETECT = 0;  // жϱ־
//			s = AnalyzeRootHub( );   // ROOT-HUB״̬
//			if ( s == ERR_USB_CONNECT ) FoundNewDev = 1;
//			if ( RootHubDev[RootHubId].DeviceStatus == ROOT_DEV_DISCONNECT ) return( ERR_USB_DISCON );  // USB豸Ͽ¼
//			if ( RootHubDev[RootHubId].DeviceStatus == ROOT_DEV_CONNECTED ) return( ERR_USB_CONNECT );  // USB豸¼
//			if ( ( USB_HUB_ST & ( bUHS_H0_ATTACH << RootHubId ) ) == 0x00 ) return( ERR_USB_DISCON );  // USB豸Ͽ¼
//			mDelayuS( 200 );  // ȴ
//		}
//		if ( UIF_TRANSFER ) {  // 
		else 
		{  
			/*  */
			mDelayuS( 200 );  // ȴ
			if ( U_TOG_OK ) return( ERR_SUCCESS );
#ifdef DEBUG_NOW
printf("endp_pid=%02X\n",(UINT16)endp_pid);
printf("USB_INT_FG=%02X\n",(UINT16)USB_INT_FG);
printf("USB_INT_ST=%02X\n",(UINT16)USB_INT_ST);
printf("USB_MIS_ST=%02X\n",(UINT16)USB_MIS_ST);
printf("USB_RX_LEN=%02X\n",(UINT16)USB_RX_LEN);
printf("UH_TX_LEN=%02X\n",(UINT16)UH_TX_LEN);
printf("UH_RX_CTRL=%02X\n",(UINT16)UH_RX_CTRL);
printf("UH_TX_CTRL=%02X\n",(UINT16)UH_TX_CTRL);
printf("UHUB01_CTRL=%02X\n",(UINT16)UHUB01_CTRL);
printf("UHUB23_CTRL=%02X\n",(UINT16)UHUB23_CTRL);
#endif
			r = USB_INT_ST & MASK_UIS_H_RES;  // USB豸Ӧ״̬ */
			if ( r == USB_PID_STALL ) return( r | ERR_USB_TRANSFER );
			if ( r == USB_PID_NAK ) {
				if ( timeout == 0 ) return( r | ERR_USB_TRANSFER );
				if ( timeout < 0xFFFF ) timeout --;
				-- TransRetry;
			}
			else switch ( endp_pid >> 4 ) {
				case USB_PID_SETUP:
				case USB_PID_OUT:
//					if ( U_TOG_OK ) return( ERR_SUCCESS );
//					if ( r == USB_PID_ACK ) return( ERR_SUCCESS );
//					if ( r == USB_PID_STALL || r == USB_PID_NAK ) return( r | ERR_USB_TRANSFER );
					if ( r ) return( r | ERR_USB_TRANSFER );  // ǳʱ/,Ӧ */
					break;  // ʱ
				case USB_PID_IN:
//					if ( U_TOG_OK ) return( ERR_SUCCESS );
//					if ( tog ? r == USB_PID_DATA1 : r == USB_PID_DATA0 ) return( ERR_SUCCESS );
//					if ( r == USB_PID_STALL || r == USB_PID_NAK ) return( r | ERR_USB_TRANSFER );
					if ( r == USB_PID_DATA0 && r == USB_PID_DATA1 ) {  // ͬ趪 */
					}  // ͬ
					else if ( r ) return( r | ERR_USB_TRANSFER );  // ǳʱ/,Ӧ */
					break;  // ʱ
				default:
					return( ERR_USB_UNKNOWN );  // ܵ */
					break;
			}
		}
//		else {  // ж,Ӧ÷
//			USB_INT_FG = 0xFF;  /* жϱ־ */
//		}
		mDelayuS( 15 );
		if ( UIF_DETECT ) {  // USB豸¼ */
			if ( USBH_Check_RootHubStatus( RootHubId ) == 0 ) return( ERR_USB_DISCON );  // USB豸Ͽ¼ */
		}
	} while( ++ TransRetry < 10 );
	return( ERR_USB_TRANSFER );  // Ӧʱ */
}

/*******************************************************************************
* Function Name  : USBH_CtrlTransfer
* Description    : USBִпƴ
*			       ִпƴ,8ֽpSetupReq,DataBufΪѡշ,
*			 	   Ҫպͷ,ôDataBufָЧڴź,
*				   ʵʳɹշܳȱReqLenָֽڱ 
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 USBH_CtrlTransfer( PUINT8X DataBuf, PUINT16 RetLen ) 
{
	UINT8	s;
	UINT16  RemLen, RxLen, RxCnt, TxCnt;
	PUINT8X	 xdata	pBuf;
	PUINT16  xdata	pLen;

	pBuf = DataBuf;
	pLen = RetLen;
	mDelayuS( 100 );
	if( pLen ) 
	{
		*pLen = 0;  															/* ʵʳɹշܳ */
	}
	UH_TX_LEN = sizeof( USB_SETUP_REQ );
	s = USBH_Transact( USB_PID_SETUP << 4 | 0x00, 0x00, DEF_CTRL_TRANS_TIMEOVER_COUNT );  /* SETUP׶,200mSʱ */
	if( s != ERR_SUCCESS ) 
	{
		return( s );
	}
	UH_RX_CTRL = UH_TX_CTRL = bUH_R_TOG | bUH_R_AUTO_TOG | bUH_T_TOG | bUH_T_AUTO_TOG;  /* ĬDATA1 */
	UH_TX_LEN = 0x01;  															/* Ĭݹ״̬׶ΪIN */
	RemLen = pSetupReq->wLengthH ? 0xFF : pSetupReq->wLengthL;
	if( RemLen && pBuf ) 
	{  
		/* Ҫշ */
		if( pSetupReq->bRequestType & USB_REQ_TYP_IN )
		{  
			/*  */
			while( RemLen ) 
			{
				mDelayuS( 100 );
				s = USBH_Transact( USB_PID_IN << 4 | 0x00, UH_RX_CTRL, DEF_CTRL_TRANS_TIMEOVER_COUNT );  /* IN */
				if( s != ERR_SUCCESS ) 
				{
					return( s );
				}
				RxLen = USB_RX_LEN < RemLen ? USB_RX_LEN : RemLen;
				RemLen -= RxLen;
				if( pLen ) 
				{
					*pLen += RxLen;  											/* ʵʳɹշܳ */
				}
				for( RxCnt = 0; RxCnt != RxLen; RxCnt ++ ) 
				{
					*pBuf = RxBuffer[ RxCnt ];
					pBuf++;
				}

				if( USB_RX_LEN == 0 || ( USB_RX_LEN & ( UsbDevEndp0Size - 1 ) ) )
				{ 
					break;  													/* ̰ */
				}
			}
			UH_TX_LEN = 0x00;  													/* ״̬׶ΪOUT */
		}
		else 
		{  
			/*  */
			while( RemLen ) 
			{
				mDelayuS( 100 );
				UH_TX_LEN = RemLen >= UsbDevEndp0Size ? UsbDevEndp0Size : RemLen;
				for( TxCnt = 0; TxCnt != UH_TX_LEN; TxCnt ++ ) 
				{
					TxBuffer[ TxCnt ] = *pBuf;
					pBuf++;
				}
				s = USBH_Transact( USB_PID_OUT << 4 | 0x00, UH_TX_CTRL, DEF_CTRL_TRANS_TIMEOVER_COUNT );  /* OUT */
				if( s != ERR_SUCCESS ) 
				{
					return( s );
				}
				RemLen -= UH_TX_LEN;
				if( pLen ) 
				{
					*pLen += UH_TX_LEN;  										/* ʵʳɹշܳ */
				}
			}
//			UH_TX_LEN = 0x01;  													/* ״̬׶ΪIN */
		}
	}
	mDelayuS( 100 );
	s = USBH_Transact( ( UH_TX_LEN ? USB_PID_IN << 4 | 0x00: USB_PID_OUT << 4 | 0x00 ), bUH_R_TOG | bUH_T_TOG, DEF_CTRL_TRANS_TIMEOVER_COUNT );  /* STATUS׶ */
	if ( s != ERR_SUCCESS ) return( s );
	if ( UH_TX_LEN == 0 ) return( ERR_SUCCESS );  								/* ״̬OUT */
	if( USB_RX_LEN == 0 )
	{ 
		return( ERR_SUCCESS );  												/* ״̬IN,IN״̬ݳ */
	}
	return( ERR_USB_BUF_OVER );  												/* IN״̬׶δ */
}

/*******************************************************************************
* Function Name  : USBH_CopySetupReqPkg
* Description    : USBƿƴ
* Input          : pReqPkt: ݻ
* Output         : None
* Return         : None
*******************************************************************************/
void USBH_CopySetupReqPkg( PUINT8C pReqPkt )  
{
	UINT8  i;

	for( i = 0; i != sizeof( USB_SETUP_REQ ); i++ ) 
	{
		((PUINT8X)pSetupReq)[ i ] = *pReqPkt;
		pReqPkt++;
	}
}

/*******************************************************************************
* Function Name  : USBH_GetDeviceDescr
* Description    : USBȡ豸
* Input          : pbuf: ݻ
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 USBH_GetDeviceDescr( UINT8 *pbuf )  
{
	UINT8	s;
	UINT16	len;

	UsbDevEndp0Size = DEFAULT_ENDP0_SIZE;
	USBH_CopySetupReqPkg( SetupGetDevDescr );
	s = USBH_CtrlTransfer( pbuf, &len );  										/* ִпƴ	*/
	if( s != ERR_SUCCESS ) 
	{
		return( s );
	}

	/* ˵0,Ǽ򻯴,ӦȻȡǰ8ֽںUsbDevEndp0Sizeټ */
	UsbDevEndp0Size = ( (PXUSB_DEV_DESCR)pbuf )->bMaxPacketSize0; 
	if( len < ( (PUSB_SETUP_REQ)SetupGetDevDescr )->wLengthL ) 
	{
		/* ȴ */
		return( ERR_USB_BUF_OVER );  
	}
	return( ERR_SUCCESS );
}

/*******************************************************************************
* Function Name  : USBH_GetConfigDescr
* Description    : USBȡ
* Input          : pbuf: ݻ
*				   plen: ݳ	 
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 USBH_GetConfigDescr( UINT8 *pbuf, UINT16 *plen )   
{
	UINT8	s;
	UINT16	len;

	/* Ȼȡǰ4ֽڵ */
	USBH_CopySetupReqPkg( SetupGetCfgDescr );
	s = USBH_CtrlTransfer( pbuf, &len );  										/* ִпƴ */
	if( s != ERR_SUCCESS ) 
	{
		return( s );
	}
	if( len < ( (PUSB_SETUP_REQ)SetupGetCfgDescr )->wLengthL ) 
	{
		return( ERR_USB_BUF_OVER );  											/* سȴ */
	}

	/* ٻȡ */
	len = ( (PXUSB_CFG_DESCR)pbuf )->wTotalLengthL | ( (UINT16)( ( (PXUSB_CFG_DESCR)pbuf )->wTotalLengthH ) << 8 );
	if( len > DEF_COM_BUF_LEN  )
	{
		len = DEF_COM_BUF_LEN; 
	}
	USBH_CopySetupReqPkg( SetupGetCfgDescr );
	pSetupReq->wLengthL = (UINT8)len;
	pSetupReq->wLengthH = (UINT8)( len >> 8 ); 
	s = USBH_CtrlTransfer( pbuf, &len );
	*plen = len;						
	return( s );
}

/*******************************************************************************
* Function Name  : USBH_GetStrDescr
* Description    : USBȡַ
* Input          : *pbuf: ݻ
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 USBH_GetStrDescr( UINT8 num, UINT8 *pbuf )  
{
	UINT8	s;
	UINT16 len;

	/* Ȼȡǰ4ֽڵַ */
	USBH_CopySetupReqPkg( SetupGetStrDescr );
	pSetupReq->wValueL = num;
	pSetupReq->wValueH = USB_DESCR_TYP_STRING;
	s = USBH_CtrlTransfer( pbuf, &len );                         
	if( s != ERR_SUCCESS ) 
	{
		return( s );
	}
	
	/* ٻȡַ */
	len = pbuf[ 0 ];	
	USBH_CopySetupReqPkg( SetupGetStrDescr );
	pSetupReq->wValueL = num;
	pSetupReq->wValueH = USB_DESCR_TYP_STRING;
	pSetupReq->wLengthL = len;                                     
	s = USBH_CtrlTransfer( pbuf, &len );                         
	if( s != ERR_SUCCESS ) 
	{
		return( s );
	}
	return( ERR_SUCCESS );
}
		
/*******************************************************************************
* Function Name  : USBH_SetUsbAddress
* Description    : USBUSB豸ַ
* Input          : addr: ǰҪõĵֵַ
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 USBH_SetUsbAddress( UINT8 addr )   
{
	UINT8  s;

	USBH_CopySetupReqPkg( SetupSetUsbAddr );
	pSetupReq->wValueL = addr;  												/* USB豸ַ */
	s = USBH_CtrlTransfer( NULL, NULL );  										/* ִпƴ */
	if( s != ERR_SUCCESS ) 
	{
		return( s );
	}
	USBH_SetSelfAddr( addr );  													/* USBǰUSB豸ַ */
	mDelaymS( BUS_RESET_TIME >> 1 );  											/* ȴUSB豸ɲ */
	return( ERR_SUCCESS );
}

/*******************************************************************************
* Function Name  : USBH_SetUsbConfig
* Description    : USBUSB豸
* Input          : cfg: ǰҪõֵ
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 USBH_SetUsbConfig( UINT8 cfg )   
{
	USBH_CopySetupReqPkg( SetupSetUsbConfig );
	pSetupReq->wValueL = cfg;  
	return( USBH_CtrlTransfer( NULL, NULL ) );  
}

/*******************************************************************************
* Function Name  : USBH_ClearEndpStall
* Description    : USB˵STALL
* Input          : endp: ǰҪĶ˵
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 USBH_ClearEndpStall( UINT8 endp )   
{
	USBH_CopySetupReqPkg( SetupClrEndpStall );  
	pSetupReq->wIndexL = endp; 
	return( USBH_CtrlTransfer( NULL, NULL ) ); 
}

/*******************************************************************************
* Function Name  : USBH_Init
* Description    : USBʼ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USBH_Init( void )  
{
	UINT8  i;
 
	IE_USB = 0;
	USB_CTRL = bUC_HOST_MODE;  													/* 趨ģʽ */
	USB_DEV_AD = 0x00;
	UH_EP_MOD = bUH_EP_TX_EN | bUH_EP_RX_EN ;
	UH_RX_DMA = RxBuffer;
	UH_TX_DMA = TxBuffer;
	UH_RX_CTRL = 0x00;
	UH_TX_CTRL = 0x00;
	UHUB23_CTRL = UHUB01_CTRL = bUH1_PD_EN | bUH0_PD_EN;
	USB_CTRL = bUC_HOST_MODE | bUC_INT_BUSY;  									/* USBDMA,жϱ־δǰԶͣ */
	UH_SETUP = bUH_SOF_EN;
	USB_INT_FG = 0xFF;  														/* жϱ־ */
	for( i = 0; i != 4; i ++ ) 
	{
		USBH_DisableRootHubPort( i );  												/*  */
		RootHubDev[ i ].bSpeed = 1;
		RootHubDev[ i ].bEp0MaxPks = 8;
	}
	USB_INT_EN = bUIE_TRANSFER | bUIE_DETECT;
//	IE_USB = 1;  																/* ѯʽ */
}







